#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

    [TestFixture]
    public class DAL_BloodUnit : BaseTest 
    {

		private System.DateTime _startDate = System.DateTime.Now.AddYears(-5);
		private System.DateTime _endDate = System.DateTime.Now.AddYears(5);

		private DataTable _dtBloodUnit;
		private DataTable _dtScanBloodType;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

            if (this.RefreshData)
            {
                System.Guid buGuid = System.Guid.NewGuid();
                BOL.BloodProduct randomBP = DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC, "E001, E002, E003, E004, E005, E006, E007, E008, E009, E049, E050, E051");
                DataCreator.CreateBloodUnit(buGuid, System.Guid.NewGuid(), System.Guid.Empty, randomBP.BloodProductGuid, false);

                this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '" + buGuid.ToString() + "'", true);

                //ScanBloodType***********************************************************
                this._dtScanBloodType = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ScanBloodType", true);

                this.RefreshData = false;
            }

		}

		[Test]
		public void GetEmptyBloodUnitTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);

			Assert.AreEqual(TABLES.BloodUnit.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RecordStatusCode), TABLES.BloodUnit.RecordStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
		}

		[Test]
		public void GetEmptyBloodUnitTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(false);

			Assert.AreEqual(TABLES.BloodUnit.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid),TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode),TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RecordStatusCode), TABLES.BloodUnit.RecordStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode),TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId),TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.ProcessingTechId),TABLES.BloodUnit.ProcessingTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EntryMethodCode), TABLES.BloodUnit.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate),TABLES.BloodUnit.UnitInDate);
		}
		[Test]
		public void GetBloodUnitDetails_Overload_Pass()
        {
			System.Guid bpGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			string unitId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string unitProductCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString() + this._dtBloodUnit.Rows[0][Common.VbecsTables.DonationType.DonationTypeCode].ToString() +   this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitDivisionId].ToString();

            DataTable dtTest = DAL.BloodUnit.GetBloodUnitDetails(unitId, bpGuid, unitProductCode);
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(45, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId),TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
					
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
					
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
        }

		[Test]
		public void GetIncomingShipmentBloodUnitDetails_Pass()
		{
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass, "").BloodProductGuid;
			//
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), Guid.Empty, bloodProductGuid, true);
			BOL.BloodUnit bloodUnit = new BOL.BloodUnit(bloodUnitGuid, bloodProductGuid);
			//
			DataTable dtTest = DAL.BloodUnit.GetIncomingShipmentBloodUnitDetails(bloodUnit.EyeReadableUnitId, bloodProductGuid, bloodUnit.ProductCode);
			//
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.LoginFullProductCode), TABLES.BloodUnitShipment.LoginFullProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.LoginValues), TABLES.BloodUnitShipment.LoginValues);
		}

		[Test]
		public void GetIncomingShipmentBloodUnitDetails_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetIncomingShipmentBloodUnitDetails(string.Empty, System.Guid.NewGuid(), string.Empty);
            
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


        [Test]
        public void GetBloodUnitDetails_Pass()
        {
			System.Guid bpGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			string unitId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();

            DataTable dtTest = DAL.BloodUnit.GetBloodUnitDetails(unitId, bpGuid);
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(45, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
					
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
					
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
        }
		
        [Test]
        public void GetBloodUnitDetails_Overload_Fail()
        {
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitDetails(string.Empty, System.Guid.NewGuid(), string.Empty);
            
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
        }
		[Test]
        public void GetBloodUnitDetails_Fail()
        {
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitDetails(string.Empty, System.Guid.NewGuid());
            
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
        }

		[Test]
		public void GetBloodUnitByUnitIdProduct_Pass()
		{
			System.Guid bpGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			string unitId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string productCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString();

			DataTable dtTest = DAL.BloodUnit.GetBloodUnitByUnitIdProduct(unitId,productCode, bpGuid);
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(24, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EntryMethodCode), TABLES.BloodUnit.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.ProcessingTechId), TABLES.BloodUnit.ProcessingTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RecordStatusCode), TABLES.BloodUnit.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateDate), TABLES.BloodUnit.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateUser), TABLES.BloodUnit.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
		}

		[Test]
		public void GetBloodUnitByUnitIdProduct_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitByUnitIdProduct(string.Empty, string.Empty, System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPhenotypeUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetPhenotypeUnits(UnitTestConfig.TestDivisionCode, true);
            
			Assert.AreEqual(49, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.SpecialTestingCost), TABLES.BloodUnitFinance.SpecialTestingCost);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber), TABLES.Shipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LocalSupplierGuid), TABLES.Shipment.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityPrefix), TABLES.LocalSupplier.FacilityPrefix);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LabelUnitIdTrimIndicator), TABLES.LocalSupplier.LabelUnitIdTrimIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingStatus.TestingStatusText), TABLES.TestingStatus.TestingStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode); 
		}

		[Test]
		public void GetPhenotypeUnits_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetPhenotypeUnits(string.Empty, true);
            
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnit.GetBloodUnitByGuid(unitGuid);
            
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(24, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.ProcessingTechId), TABLES.BloodUnit.ProcessingTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EntryMethodCode), TABLES.BloodUnit.EntryMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RecordStatusCode), TABLES.BloodUnit.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateDate), TABLES.BloodUnit.LastUpdateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateUser), TABLES.BloodUnit.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
		}

		[Test]
		public void GetBloodUnitByGuid_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitByGuid(System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetLimitedBloodUnit_Pass()
		{
			System.Guid shipGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitShipment.IncomingShipmentGuid];

			DataTable dtTest = DAL.BloodUnit.GetLimitedBloodUnit(shipGuid, true, true);

			Assert.AreEqual(43, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PendingTransferIndicator), ARTIFICIAL.PendingTransferIndicator); 

			//Test  2---
			DataTable dtTest2 = DAL.BloodUnit.GetLimitedBloodUnit(System.Guid.Empty, true, true);

			Assert.AreEqual(true, dtTest2.Rows.Count > 0, "Test2-Rows.Count");
		}

        [Test]
        public void GetLimitedBloodUnit_Fail()
        {
			DataTable dtTest = DAL.BloodUnit.GetLimitedBloodUnit(System.Guid.NewGuid(), true, true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
        }

		[Test]
		public void GetLimitedBloodUnitsByDivision_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, true, true);
			DataTable dtTest2 = DAL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false, true);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows1.Count");
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows2.Count");
			Assert.AreEqual(dtTest2.Columns.Count, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetLimitedBloodUnitsByDivision_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetLimitedBloodUnitsByDivision(string.Empty, true, true);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnits_Pass()
		{
			System.Guid shipGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitShipment.IncomingShipmentGuid];

			DataTable dtTest = DAL.BloodUnit.GetBloodUnits(shipGuid);
			Assert.AreEqual(46, dtTest.Columns.Count, "Columns.Count");		//Method adds 1 column not in sproc

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.ProcessingTechId), TABLES.BloodUnit.ProcessingTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateUser), TABLES.BloodUnit.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid), TABLES.Shipment.ShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);

		}

		
		[Test]
		public void GetBloodUnits_Fail()
		{
			DataTable dtTest2 = DAL.BloodUnit.GetBloodUnits(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest2.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitsForEdit_Pass()
		{
			//GetBloodUnitsForEdit(true)***********************************************************

			DataTable dtTest = DAL.BloodUnit.GetBloodUnitsForEdit(true);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(42, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		public void GetBloodUnitsForEdit_Fail()
		{
			DataTable dtTest1 = DAL.BloodUnit.GetBloodUnitsForEdit(true);
			DataTable dtTest2 = DAL.BloodUnit.GetBloodUnitsForEdit(false);
		
			Assert.AreEqual(true, dtTest1.Rows.Count >= dtTest2.Rows.Count, "Rows.Count");
			Assert.AreEqual(true, dtTest1.Columns.Count == dtTest2.Columns.Count, "Columns.Count");
		}

		[Test]
		public void GetBloodUnitGuid_Pass()
		{
			string unitId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string productCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString();
			string divisionId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitDivisionId].ToString();
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			System.Guid checkGuid = DAL.BloodUnit.GetBloodUnitGuid(unitId,productCode,UnitTestConfig.TestDivisionCode, divisionId);

			Assert.AreEqual(unitGuid, checkGuid, "Guid");
		}

		[Test]
		public void GetBloodUnitGuid_Fail()
		{
			try
			{
				DAL.BloodUnit.GetBloodUnitGuid("Greg", "Lohse", "Was", "Here");
				Assert.IsTrue(false, "Junk Parameters-DataAccessLayerException");
			}
			catch(Common.DataAccessLayerException)
			{
				Assert.IsTrue( true, "Junk Parameters-DataAccessLayerException");
			}

			//Blank UnitId................................................................
			try
			{
				DAL.BloodUnit.GetBloodUnitGuid(string.Empty, "10100", this.TestDivisionCode, string.Empty);
				Assert.IsTrue(false, "Blank UnitId-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Blank UnitId-ArgumentException");
			}

			//Blank ProductCode..............................................................
			try
			{
				DAL.BloodUnit.GetBloodUnitGuid("20070102", string.Empty, this.TestDivisionCode, string.Empty);
				Assert.IsTrue(false, "Blank ProductCode-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Blank ProductCode-ArgumentException");
			}

			//Blank DivisionCode..................................................
			try
			{
				DAL.BloodUnit.GetBloodUnitGuid("20070102", "10100", string.Empty, string.Empty);
				Assert.IsTrue(false, "Blank DivisionCode-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Blank DivisionCode-ArgumentException");
			}
	
		}

		[Test]
		public void GetBloodUnitsByIdAndProduct_Pass()
		{
			System.Guid bpGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			System.Guid unitGuid = System.Guid.NewGuid();

			DataCreator.CreateBloodUnit(unitGuid, System.Guid.NewGuid(), System.Guid.Empty, bpGuid, (this._dtBloodUnit.Rows[0][TABLES.BloodUnit.LabelTypeCode].ToString() == "C"));
			
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodUnit WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'", true);

			string unitId = dtTemp.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string productCode = dtTemp.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString();
			string divisionId = dtTemp.Rows[0][TABLES.BloodUnit.UnitDivisionId].ToString();
			int donationTypeId = Convert.ToInt32(dtTemp.Rows[0][TABLES.BloodUnit.DonationTypeId]);
			string donationTypeCode = DAL.DonationType.GetDonationTypeByID(donationTypeId)[TABLES.DonationType.DonationTypeCode].ToString();

            DataTable dtTest = DAL.BloodUnit.GetBloodUnitsByIdAndProduct(unitId, productCode, UnitTestConfig.TestDivisionCode,divisionId, donationTypeCode, Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus);
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(43, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);			
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);			
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RecordStatusCode), TABLES.BloodUnit.RecordStatusCode);
		}
		
		[Test]
		public void GetBloodUnitsByIdAndProduct_Fail()
		{
			//Blank Unit Id............................................................
			try
			{
				DataTable units = DAL.BloodUnit.GetBloodUnitsByIdAndProduct(string.Empty, "10100", this.TestDivisionCode, string.Empty, "V", Common.AdditionalBloodUnitSearchCriteria.None);
				Assert.IsTrue(false, "Empty UnitId-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Empty UnitId-ArgumentException");
			}

			//Blank ProductCode............................................................
			try
			{
				DataTable units = DAL.BloodUnit.GetBloodUnitsByIdAndProduct("2007010101", string.Empty, this.TestDivisionCode, string.Empty, "V", Common.AdditionalBloodUnitSearchCriteria.None);
				Assert.IsTrue(false, "Empty ProductCode-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Empty ProductCode-ArgumentException");
			}

			//Blank Divison Code............................................................
			try
			{
				DataTable units = DAL.BloodUnit.GetBloodUnitsByIdAndProduct("2007010101", "10100", string.Empty, string.Empty, "V", Common.AdditionalBloodUnitSearchCriteria.None);
				Assert.IsTrue(false, "Empty Divison-ArgumentException");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Empty Divison-ArgumentException");
			}

			//Invalid stuff
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitsByIdAndProduct("1234567890", "96X69", this.TestDivisionCode, string.Empty, "V", Common.AdditionalBloodUnitSearchCriteria.None);
			Assert.IsTrue(dtTest.Rows.Count==0, "Junk Arguments");     //CR3294 - no longer causes Exception
		}


		[Test]
		public void GetBloodTypeRHFactorFromBloodTypeCode_Pass()

		{
			DataRow dr = DAL.BloodUnit.GetBloodTypeRHFactorFromBloodTypeCode("02");

			Assert.AreEqual(4, dr.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.ScanBloodType.ScanBloodTypeCode), TABLES.ScanBloodType.ScanBloodTypeCode);
			Assert.AreEqual(true, dr.Table.Columns.Contains(ARTIFICIAL.BloodType), ARTIFICIAL.BloodType);
			Assert.AreEqual(true, dr.Table.Columns.Contains(TABLES.RhFactor.RhFactorCode), TABLES.RhFactor.RhFactorCode);
			Assert.AreEqual(true, dr.Table.Columns.Contains(ARTIFICIAL.BloodTypeRhFactor), ARTIFICIAL.BloodTypeRhFactor);
		}
        [Test]
        [ExpectedException(typeof(IndexOutOfRangeException))]
        public void GetBloodTypeRHFactorFromBloodTypeCode_Fail()
        {
            DataRow dr = DAL.BloodUnit.GetBloodTypeRHFactorFromBloodTypeCode(string.Empty);
        }

		[Test]
		public void SaveBloodUnitAndAggregates_Pass()
		{
			DataSet dsSave = new DataSet();
			DataTable dtData = null;

			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			dtBU.Columns.Add(ARTIFICIAL.PooledUnitsCount, typeof(int));		//code coverage, save will still pass
			DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);
			dtBUF.Columns.Add(TABLES.BloodUnitShipment.OutgoingShipmentGuid, typeof(System.Guid));		//code coverage, save will still pass
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);
			DataTable dtWorkload = new DataTable(TABLES.WorkloadEvent.TableName);

			dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			System.Guid buGuid = (System.Guid)dtData.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(buGuid);
			dtBU.Rows.Add(tmpUnit.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUF.Rows.Add(tmpUnit.BloodUnitFinance.LoadDataRowFromThis(dtBUF.NewRow()));
			dtBUM.Rows.Add(tmpUnit.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));
			dtBUS.Rows.Add(tmpUnit.BloodUnitStatus.LoadDataRowFromThis(dtBUS.NewRow()));

			dsSave.Tables.Add(dtBU);
			dsSave.Tables.Add(dtBUF);
			dsSave.Tables.Add(dtBUM);
			dsSave.Tables.Add(dtBUS);
			dsSave.Tables.Add(dtWorkload);

			bool retValue = DAL.BloodUnit.SaveBloodUnitAndAggregates(dsSave, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");			
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveBloodUnitAndAggregates_Fail()
		{
			DataSet dsSave = new DataSet();
			DataTable dtData = null;

			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			System.Guid buGuid = (System.Guid)dtData.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(buGuid);
			dtBU.Rows.Add(tmpUnit.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUF.Rows.Add(tmpUnit.BloodUnitFinance.LoadDataRowFromThis(dtBUF.NewRow()));
			dtBUM.Rows.Add(tmpUnit.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));
			dtBUS.Rows.Add(tmpUnit.BloodUnitStatus.LoadDataRowFromThis(dtBUS.NewRow()));

			//Simulate Lohse's code, by screwing up the RowVersions and then attempt to save
			dtBU.Rows[0][TABLES.BloodUnit.RowVersion] = new byte[8];
			dtBUF.Rows[0][TABLES.BloodUnitFinance.RowVersion] = new byte[8];
			dtBUM.Rows[0][TABLES.BloodUnitMedia.RowVersion] = new byte[8];
			dtBUS.Rows[0][TABLES.BloodUnitStatus.RowVersion] = new byte[8];

			dsSave.Tables.Add(dtBU);
			dsSave.Tables.Add(dtBUF);
			dsSave.Tables.Add(dtBUM);
			dsSave.Tables.Add(dtBUS);
			
			bool retValue = DAL.BloodUnit.SaveBloodUnitAndAggregates(dsSave, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(false, retValue, "ReturnValue");	
		}

		[Test]
		public void Save_5DataTables_Pass()
		{
			this.RefreshData = true;
			
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit tmpBU = new BOL.BloodUnit(unitGuid);

			//Get the inital tables
			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			dtBU.Rows.Add(tmpBU.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUM.Rows.Add(tmpBU.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));
			dtBUS.Rows.Add(tmpBU.BloodUnitStatus.LoadDataRowFromThis(dtBUS.NewRow()));

			//Load the Tables
			DataTable dtEmpty = new DataTable();

			bool retValue = DAL.BloodUnit.Save(dtBU, true, dtBUM, dtBUS, dtEmpty, dtEmpty, dtEmpty, null,  Common.UpdateFunction.UnitTests);			
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Save_5DataTables_Fail()
		{
			this.RefreshData = true;
			
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit tmpBU = new BOL.BloodUnit(unitGuid);

			// Get the inital tables
			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			dtBU.Rows.Add(tmpBU.LoadDataRowFromThis(dtBU.NewRow()));
			dtBUM.Rows.Add(tmpBU.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));
			dtBUS.Rows.Add(tmpBU.BloodUnitStatus.LoadDataRowFromThis(dtBUS.NewRow()));
			//
			// Testing quaratine ...
			dtBUS.Rows[0][TABLES.BloodUnitStatus.QuarantineCannedCommentGuid] = DBNull.Value;
			dtBUS.Rows[0][TABLES.BloodUnitStatus.QuarantineIndicator] = 1;
			dtBUS.Rows[0][TABLES.BloodUnitStatus.UnitStatusComments] = "UnitTest.DAL.BloodUnit.Save Quarantine Test";
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.QuarantineUnit);
			Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.QuarantineUnit;
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(workloadProcessID, new Guid[]{ unitGuid }, Common.WorkloadTransactionType.Unit, false);
			//
			dtBU.Rows[0][TABLES.BloodUnit.RowVersion] = new byte[8];
			dtBUM.Rows[0][TABLES.BloodUnitMedia.RowVersion] = new byte[8];
			dtBUS.Rows[0][TABLES.BloodUnitStatus.RowVersion] = new byte[8];

			// Load the Tables
			DataTable dtEmpty = new DataTable();

			bool retValue = DAL.BloodUnit.Save(dtBU, true, dtBUM, dtBUS,  dtEmpty, dtEmpty, dtWorkload, null,  Common.UpdateFunction.UnitTests);			
			Assert.AreEqual(true, retValue, "ReturnValue");			
		}

		[Test]
		public void GetBloodUnitsInFinalStatus_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetBloodUnitsInFinalStatus();
			
			Assert.AreEqual(42, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);			
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);			
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);			

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodUnitsInFinalStatus_Fail()
		{
		}

		[Test]
		public void RemoveFinalStatus_Pass()
		{
			DataTable dt = DAL.BloodUnit.GetBloodUnitsInFinalStatus();
			if (dt.Rows.Count>0)
			{
				//Creating data for directed patient
				Guid unitGUID = (Guid)dt.Rows[0]["BloodUnitGuid"];
				BOL.BloodUnit tmpBU = new BOL.BloodUnit(unitGUID);

				DataTable dtFinal = DAL.BloodUnitStatus.GetBloodUnitStatusByGuid(unitGUID);
				if (dtFinal.Rows.Count>0)
				{
					DataTable dtPrevious = DAL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(unitGUID);
					//
					if (dtPrevious.Rows.Count>0)
					{
						DataTable dtFinance = DAL.BloodUnitFinance.GetBloodUnitFinanceByUnitGuid(unitGUID);
						if (dtFinance.Rows.Count>0)
						{
							tmpBU.BloodUnitFinance.ReturnCreditAmount = 0;
							
							Guid [] bloodUnitGuids = new Guid[1];
							bloodUnitGuids[0] = tmpBU.BloodUnitGuid;

							DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);
							dtBUS.Rows.Add(tmpBU.BloodUnitStatus.LoadDataRowFromThis(dtBUS.NewRow()));
							
							DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);
							dtBUF.Rows.Add(tmpBU.BloodUnitFinance.LoadDataRowFromThis(dtBUF.NewRow()));

							DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);		//Why do we have an internal method on BOL? pff
							tmpBU.BloodUnitMedia.DirectedPatientGuid = DataCreator.GetRandomRecordGuid("Patient", "");
							dtBUM.Columns.Remove(TABLES.BloodUnitMedia.TestingStatusId);
							dtBUM.Columns.Remove(TABLES.BloodUnitMedia.BloodTypeCode);
							dtBUM.Columns.Remove(TABLES.BloodUnitMedia.RhFactorCode);
							dtBUM.Columns.Remove(TABLES.BloodUnitMedia.UnitExpirationDate);
							dtBUM.Rows.Add(tmpBU.BloodUnitMedia.LoadDataRowFromThis(dtBUM.NewRow()));
							dtBUM.Rows[0][TABLES.BloodUnitMedia.RemoveRestrictionDate] = System.DateTime.Now;
							dtBUM.Rows[0][TABLES.BloodUnitMedia.RemoveRestrictionTechId] = Common.LogonUser.LogonUserName;
							dtBUM.Rows[0][TABLES.BloodUnitMedia.Comments] = "DAL.BloodUnit.RemoveFinalStatus_Pass()";
							DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
							DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.TransfuseUnit, bloodUnitGuids, Common.WorkloadTransactionType.Unit, true);
							bool retValue = DAL.BloodUnit.RemoveFinalStatus(dtBUS, dtBUM, dtBUF,Common.UpdateFunction.UnitTests, dtWorkloadEvents, new DataTable(),new DataTable(),new DataTable(),new DataTable(),null);
							
							Assert.AreEqual(true, retValue, "ReturnValue");
							return;
						}
					}
				}
			}			
			Assert.IsTrue(false, "Somewhere failed");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void RemoveFinalStatus_Fail()
		{
			DAL.BloodUnit.RemoveFinalStatus(new DataTable(),new DataTable(),new DataTable(),Common.UpdateFunction.Invalid, null, new DataTable(),new DataTable(),new DataTable(),new DataTable(),null);
		}

		[Test]
		public void RemoveUnitModification_Pass()
		{
			this.RefreshData = true;

			//Can't do this to pools or splits
			DataTable dtData1 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitModification WHERE ProductModificationCode NOT IN ('P','S','U') AND DivisionCode = '" + this.TestDivisionCode + "' AND ToBloodUnitGuid IN (SELECT BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A')");

			System.Guid unitGuid = (System.Guid)dtData1.Rows[0][TABLES.BloodUnitModification.ToBloodUnitGuid];
			System.Guid bumGuid = (System.Guid)dtData1.Rows[0][TABLES.BloodUnitModification.BloodUnitModificationGuid];
			byte[] bumRowVersion = (byte[])dtData1.Rows[0][TABLES.BloodUnitModification.RowVersion];

			DataTable dtBUM = SprocHelper.GetUpdateBloodUnitModificationStatusSprocTable(bumGuid, "A", bumRowVersion);
			DataTable dtMedia = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);

			DataTable dtData2 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			DataRow drMedia = dtMedia.NewRow();
			foreach(DataColumn dc in dtData2.Columns)
			{
				if(dtMedia.Columns.Contains(dc.ColumnName))
				{
					drMedia[dc.ColumnName] = dtData2.Rows[0][dc.ColumnName];
				}
			}
			drMedia[TABLES.BloodUnit.DivisionCode] = this.TestDivisionCode;
			dtMedia.Rows.Add(drMedia);

			DataTable dtData3 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			DataRow drBU = dtBU.NewRow();
			foreach(DataColumn dc in dtData3.Columns)
			{
				if(dtBU.Columns.Contains(dc.ColumnName))
				{
					drBU[dc.ColumnName] = dtData3.Rows[0][dc.ColumnName];
				}
			}
			dtBU.Rows.Add(drBU);

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(unitGuid);

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Final_unit_status_removed, "UnitTest(7481)@" + System.DateTime.Now.ToString(), Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionRemoveUnitModification(tmpUnit, dtData1.Rows[0]);
			DataTable dtException = exRep.ExceptionData.Table.Clone();
			dtException.Rows.Add(exRep.ExceptionData.ItemArray);

			bool retValue = DAL.BloodUnit.RemoveUnitModification(dtBU, dtBUM, dtMedia, Common.UpdateFunction.UnitTests, dtException, new DataTable(), new DataTable(),null);

			Assert.AreEqual(true, retValue, "ReturnValue");

		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void RemoveUnitModification_Fail()
		{
			//Can't do this to pools or splits
			DataTable dtData1 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitModification WHERE ProductModificationCode NOT IN ('P','S','U') AND DivisionCode = '" + this.TestDivisionCode + "' AND ToBloodUnitGuid IN (SELECT BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A')");

			System.Guid unitGuid = (System.Guid)dtData1.Rows[0][TABLES.BloodUnitModification.ToBloodUnitGuid];
			System.Guid bumGuid = (System.Guid)dtData1.Rows[0][TABLES.BloodUnitModification.BloodUnitModificationGuid];
			byte[] bumRowVersion = new byte[8];

			DataTable dtBUM = SprocHelper.GetUpdateBloodUnitModificationStatusSprocTable(bumGuid, "A", bumRowVersion);
			DataTable dtMedia = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);

			DataTable dtData2 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			DataRow drMedia = dtMedia.NewRow();
			foreach(DataColumn dc in dtData2.Columns)
			{
				if(dtMedia.Columns.Contains(dc.ColumnName))
				{
					drMedia[dc.ColumnName] = dtData2.Rows[0][dc.ColumnName];
				}
			}
			drMedia[TABLES.BloodUnit.DivisionCode] = this.TestDivisionCode;
			drMedia[TABLES.BloodUnitMedia.RowVersion] = new byte[8];
			dtMedia.Rows.Add(drMedia);

			DataTable dtData3 = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			DataRow drBU = dtBU.NewRow();
			foreach(DataColumn dc in dtData3.Columns)
			{
				if(dtBU.Columns.Contains(dc.ColumnName))
				{
					drBU[dc.ColumnName] = dtData3.Rows[0][dc.ColumnName];
				}
			}
			drBU[TABLES.BloodUnit.RowVersion] = new byte[8];
			dtBU.Rows.Add(drBU);

			BOL.BloodUnit tmpUnit = new BOL.BloodUnit(unitGuid);

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Final_unit_status_removed, "UnitTest(7481)@" + System.DateTime.Now.ToString(), Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionRemoveUnitModification(tmpUnit, dtData1.Rows[0]);
			DataTable dtException = exRep.ExceptionData.Table.Clone();
			dtException.Rows.Add(exRep.ExceptionData.ItemArray);

			bool retValue = DAL.BloodUnit.RemoveUnitModification(dtBU, dtBUM, dtMedia, Common.UpdateFunction.UnitTests, dtException, new DataTable(), new DataTable(),null);

		}


		[Test]
		public void GetBloodUnitsElgibleForCrossover_Pass()
		{
			// Make sure we have a directed/restricted blood to use
			// If not, create one
			DataTable dtTest = BOL.BloodUnit.GetBloodUnitsEligibleForCrossover();
			if (dtTest == null || dtTest.Rows.Count == 0)
			{
				SetupDirectedUnitData();
				dtTest = DAL.BloodUnit.GetBloodUnitsEligibleForCrossover();
			}

			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(45, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);			
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetBloodUnitsElgibleForCrossover_Fail()
		{
		}

		[Test]
		public void FreeDirectedBloodUnit_Pass()
		{
			this.RefreshData = true;

			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit tmpBU = new BOL.BloodUnit(unitGuid);

			DataTable dtUnit = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtMedia = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtWorkload = new DataTable();

			dtUnit.Rows.Add(tmpBU.LoadDataRowFromThis(dtUnit.NewRow()));
			dtMedia.Rows.Add(tmpBU.BloodUnitMedia.LoadDataRowFromThis(dtMedia.NewRow()));

			// Generate exception report
			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Release_patient_restriction, "UNIT TEST", Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionPatientRestriction(new BOL.BloodUnit((Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]));
			DataTable dtExceptionPatientRestriction = exRep.ExceptionData.Table.Clone();

			dtUnit.Rows[0][TABLES.BloodUnit.DonationTypeId] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.DonationTypeId];

			bool retValue = DAL.BloodUnit.FreeDirectedUnit(dtUnit, dtMedia, dtWorkload, dtExceptionPatientRestriction, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue"); 
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void FreeDirectedBloodUnit_Fail()
		{
			DAL.BloodUnit.FreeDirectedUnit(new DataTable(), new DataTable(), new DataTable(), new DataTable(), Common.UpdateFunction.Invalid);
		}

		[Test]
		public void GetAssignedPatientCount_Pass()
		{
			// Grab the first assigned Blood Unit
			System.Text.StringBuilder query = new System.Text.StringBuilder("SELECT TOP 1(BloodUnitGuid) ");
			query.Append("FROM vw_BloodShipAllCurrent as vwBLWCS ");
			query.Append("WHERE (SELECT COUNT(1) FROM dbo.Patient ");
			query.Append("JOIN dbo.PatientTreatment ON dbo.Patient.PatientGuid = PatientTreatment.PatientGuid ");
			query.Append("JOIN dbo.PatientOrder ON dbo.PatientTreatment.PatientTreatmentGuid = dbo.PatientOrder.PatientTreatmentGuid ");
			query.Append("JOIN dbo.OrderedComponent ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid ");
			query.Append("JOIN dbo.OrderedUnit ON dbo.OrderedComponent.OrderedComponentGuid = dbo.OrderedUnit.OrderedComponentGuid ");
			query.Append("AND dbo.OrderedUnit.BloodUnitGuid = vwBLWCS.BloodUnitGuid) > 0");

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), true);

			System.Guid bug = (System.Guid)dtTemp.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
		
			Assert.IsTrue(DAL.BloodUnit.GetAssignedPatientCount(bug) >= 0, "Unit is not assigned!");
		}

		[Test]
		public void GetAssignedPatientCount_Fail()
		{
			int intCount = DAL.BloodUnit.GetAssignedPatientCount(System.Guid.NewGuid());
			Assert.AreEqual(0, intCount, "PatientCount");
		}

		[Test]
		public void GetDiscardedUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetDiscardedUnits(System.DateTime.Now.AddYears(-1), System.DateTime.Now);
			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");

			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusDate), TABLES.BloodUnitStatus.UnitStatusDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.ReturnCreditAmount), TABLES.BloodUnitFinance.ReturnCreditAmount);
		}

		[Test]
		public void GetDiscardedUnits_Fail()
		{
			DataTable dtDiscardedUnits = DAL.BloodUnit.GetDiscardedUnits(System.DateTime.Now.AddYears(1), System.DateTime.Now);
			Assert.AreEqual(0, dtDiscardedUnits.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetAdminReportBloodUnitsDiscarded_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsDiscarded(this._startDate, this._endDate, true, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsDiscarded_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsDiscarded(this._endDate, this._startDate, true, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAdminReportBloodUnitsModifiedPrepared_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsModifiedPrepared(this._startDate, this._endDate,  true, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.ProductModificationCode), TABLES.ProductModification.ProductModificationCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ToBloodUnitGuid), TABLES.BloodUnitModification.ToBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsModifiedPrepared_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsModifiedPrepared(this._endDate, this._startDate, true, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAdminReportBloodUnitsOutdated_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsOutdated(this._startDate, true, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsOutdated_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsOutdated(this._endDate, true, String.Empty);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAdminReportBloodUnitsReceived_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsReceived(this._startDate, this._endDate, true, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsReceived_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsReceived(this._endDate, this._startDate, true, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAdminReportBloodUnitsShipped_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsShipped(this._startDate, this._endDate, true, UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsShipped_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsShipped(this._endDate, this._startDate, true, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAdminReportBloodUnitsTransfused_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsTransfused(this._startDate, this._endDate, true, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DiscardedPlasmaVolume), TABLES.BloodUnit.DiscardedPlasmaVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ProductType.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CMVNegative), ARTIFICIAL.CMVNegative);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.SCNegative), ARTIFICIAL.SCNegative);
		}
		
		[Test]
		public void GetAdminReportBloodUnitsTransfused_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetAdminReportBloodUnitsTransfused(this._endDate, this._startDate, true, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetInactivatedUnitsList_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetInactivatedUnitsList(this._startDate, this._endDate);

			Assert.IsTrue(dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LastUpdateDate), TABLES.BloodUnit.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitFinance.UnitCost), TABLES.BloodUnitFinance.UnitCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
		}
		
		[Test]
		public void GetInactivatedUnitsList_Fail()
		{
			DataTable dtTest = DAL.BloodUnit.GetInactivatedUnitsList(this._endDate, this._startDate);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetModifiedBloodUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnit.GetModifiedBloodUnits();
			Assert.AreEqual(42, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);	
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetModifiedBloodUnits_Fail()
		{
		}

		[Test]
		public void BloodUnitExists_Pass()
		{
			DataRow drBloodUnit = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode <> 'X'");
			Assert.IsFalse( drBloodUnit.IsNull(TABLES.BloodUnit.BloodUnitGuid) );
			Assert.IsTrue( DAL.BloodUnit.BloodUnitExists((Guid)drBloodUnit[TABLES.BloodUnit.BloodUnitGuid]) );
		}

		[Test]
		public void BloodUnitExists_Fail()
		{
			Assert.IsFalse( DAL.BloodUnit.BloodUnitExists(Guid.Empty) );
		}

		#region Helper Methods

		private void SetupDirectedUnitData()
		{
			// Set up 1 blood unit that matches the req'd conditions
			System.Text.StringBuilder query = new System.Text.StringBuilder("UPDATE BloodUnit ");
			query.Append("SET DonationTypeId = 12 WHERE BloodUnitGuid IN (");
			query.Append("SELECT TOP 1(BloodUnitGuid) FROM vw_BloodShipAllCurrent as vwBLWCS ");
			query.Append("WHERE vwBLWCS.DivisionCode = '").Append(UnitTestConfig.TestDivisionCode).Append("' ");
			query.Append("AND (vwBLWCS.UnitStatusCode NOT IN ('D', 'M', 'T', 'X')) ");
			query.Append("AND (vwBLWCS.DirectedPatientGuid IS NOT NULL)");
			query.Append("AND (SELECT COUNT(1) from dbo.Patient ");
			query.Append("JOIN dbo.PatientTreatment ON dbo.Patient.PatientGuid = PatientTreatment.PatientGuid ");
			query.Append("JOIN dbo.PatientOrder ON dbo.PatientTreatment.PatientTreatmentGuid = dbo.PatientOrder.PatientTreatmentGuid ");
			query.Append("JOIN dbo.OrderedComponent ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid ");
			query.Append("JOIN dbo.OrderedUnit ON dbo.OrderedComponent.OrderedComponentGuid = dbo.OrderedUnit.OrderedComponentGuid ");
			query.Append("AND dbo.OrderedUnit.BloodUnitGuid = vwBLWCS.BloodUnitGuid) = 0 )");

			int retValue = UnitTestUtil.RunSQL(query.ToString());
		}

		#endregion

    }
}
#endif
